<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\BonusLedger;
use App\Models\User;
use App\Models\UserLedger;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(Request $request, $id = null)
    {
        if ($id) {
            User::find($id)->delete();
        }

        $captcha_code = rand(10000, 99999);
        $ref_by = $request->query('shareCode');

        return view('app.auth.registration', compact('ref_by', 'captcha_code'));
    }

    /**
     * Handle an incoming registration request.
     */
    public function store(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'phone'    => ['required', 'numeric', 'unique:users,phone'],
            'ref_by'   => ['required', 'string'],
            'password' => ['required', 'min:6'],
        ], [
            'ref_by.required' => 'Refer code is required',
        ]);

        if ($validate->fails()) {
            return back()->with('message', $validate->errors()->first());
        }

        $ip = $request->ip();
        $registrationBonus = 75; // Static bonus, can be made dynamic from settings

        $user = User::create([
            'username'       => 'uname' . $request->phone,
            'ref_id'         => $this->ref_code(),
            'ref_by'         => $request->ref_by,
            'email'          => time() . rand(0, 999) . '@gmail.com',
            'password'       => Hash::make($request->password),
            'type'           => 'user',
            'phone'          => $request->phone,
            'balance'        => $registrationBonus, // Bonus added to wallet
            'phone_code'     => '+27',
            'ip'             => $ip,
            'remember_token' => Str::random(30),
        ]);

        // Save to bonus ledger (can be customized more)
        $bonus_ledger = new BonusLedger();
        $bonus_ledger->user_id = $user->id;
        $bonus_ledger->bonus_code = '---';
        $bonus_ledger->amount = 0;
        $bonus_ledger->date = now();
        $bonus_ledger->save();

        // Save to user ledger (bonus entry)
        $user_ledger = new UserLedger();
        $user_ledger->user_id = $user->id;
        $user_ledger->reason = 'registration_bonus';
        $user_ledger->perticulation = 'Registration Bonus';
        $user_ledger->amount = $registrationBonus;
        $user_ledger->credit = $registrationBonus;
        $user_ledger->debit = 0;
        $user_ledger->status = 'approved';
        $user_ledger->date = now()->format('d-m-Y H:i');
        $user_ledger->save();

        // Auto-login user
        Auth::login($user);

        return redirect()->route('home')->with('success', 'Registration successful! R' . $registrationBonus . ' bonus added.');
    }

    /**
     * Generate a random referral code.
     */
    public function ref_code()
    {
        $rand1 = rand(10000000, 99999999);
        $rand2 = rand(10000000, 99999999);

        return rand(111, 999) % 2 == 0 ? $rand1 : $rand2;
    }

    /**
     * Refresh CAPTCHA (optional if you’re using image CAPTCHA).
     */
    public function refreshCaptcha()
    {
        return response()->json(['captcha' => captcha_img()]);
    }
}
